#!/usr/bin/python

import os
import re
import sys
import uuid
import string
import fileinput

isl_file = r'WALSetup/WALSetup.isl'
version_numbers = {'major': '00',
                   'minor': '00',
                   'fix': '0000',
                   'build': '01',
                   'version': '0.0.0.1'}

def set_productversion(file, new_version):
    with fileinput.input(files=(file), inplace=1, backup='.bak') as f:
        for line in f:
            line = re.sub(r'>ProductVersion</td><td>[0-9.]*<', 
                          r'>ProductVersion</td><td>{}<'.format(new_version), 
                          line.rstrip())
            print(line)

def set_productcode(file):
    with fileinput.input(files=(file), inplace=1, backup='.bak') as f:
        for line in f:
            line = re.sub(r'>ProductCode</td><td>[{}0-9A-Fa-f-]+<',
                          r'>ProductCode</td><td>{}<'.format('{' +
                                                             str(uuid.uuid4()).upper() + '}'),
                          line.rstrip())
            print(line)

if len(sys.argv) == 2:
    if '.' in sys.argv[1]:
        v1, v2, v3, v4 = sys.argv[1].split('.')
        version_numbers['major'] = int(v1)
        version_numbers['minor'] = int(v2)
        version_numbers['fix'] = int(v3)
        version_numbers['build'] = int(v4)
    else:
        version_numbers['build'] = int(sys.argv[1])
elif len(sys.argv)== 5:
    version_numbers['major'] = int(sys.argv[1])
    version_numbers['minor'] = int(sys.argv[2])
    version_numbers['fix'] = int(sys.argv[3])
    version_numbers['build'] = int(sys.argv[4])
elif len(sys.argv) > 1:
    version_numbers['build'] = int(sys.argv[1])

version_numbers['version'] = '{}.{}.{}.{}'.format(version_numbers['major'],
                                                  version_numbers['minor'],
                                                  version_numbers['fix'],
                                                  version_numbers['build'])

set_productversion(isl_file, version_numbers['version'])
set_productcode(isl_file)