﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace SampleApp
{
	public partial class OnlookerDetectedForm : Form
	{
		private readonly int[] snoozeTimeOptions = new int[] { 1, 3, 5, 10, 15, 20, 25, 30, 40, 50, 60, 120, 300, 600 };
		public int snoozeTime = 0;

		public OnlookerDetectedForm()
		{
			InitializeComponent();
			InitializeSnoozeValues();
		}

		private void InitializeSnoozeValues()
		{
			this.onlookerSnoozeComboBox.Items.AddRange(Array.ConvertAll(snoozeTimeOptions, x => x.ToString() + " Seconds"));
		}

		private void onlookerSnoozeComboBox_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (sender is ComboBox && ((ComboBox)sender).SelectedIndex < snoozeTimeOptions.Length)
			{
				this.snoozeTime = snoozeTimeOptions[((ComboBox)sender).SelectedIndex] * 1000;
			}
		}
	}
}
